//
// Copyright (c) 1998-2002 B2C2, Inc.  All Rights Reserved.
//

// TimeShiftRecFile.h

// Note: Contains interfaces CTimeShiftRecFile

#ifndef _TIMESHIFTRECFILE_H_
#define _TIMESHIFTRECFILE_H_


//#define MAX_PATH_NAME	512

///////////////////////////////////////////////////////////////////////////////
//
// CTimeShiftRecFile
//

class CTimeShiftRecFile
{
public:	// Constructor/Destructor
	CTimeShiftRecFile();
	virtual ~CTimeShiftRecFile();

public: // Definitions
	enum E_TSR_FILE_TYPE
	{
		TSRF_UNKNOWN = 0,
		TSRF_RECORD,
		TSRF_PLAY,
		TSRF_TIME_SHIFT,
	};

public: // interface functions
	HRESULT SetFileName(LPCOLESTR pszFileName);
	HRESULT SetFileType(E_TSR_FILE_TYPE eType);

    HRESULT OpenFile();
    HRESULT CloseFile();

	HRESULT Write(PVOID pData, DWORD dwLength);
	HRESULT Read(PVOID pData, DWORD dwLength, DWORD* dwRead);

	BOOL	IsOpen() { return m_hFile != INVALID_HANDLE_VALUE; };

	HRESULT Reposition(__int64 i64DistanceToMove, DWORD dwMoveMethod, __int64* pi64FilePosition = NULL);
	HRESULT GetFileSize( __int64* pi64FileSize);

	HRESULT Delete( void );

private: // Member variables
    HANDLE		m_hFile;			// Handle to file for dumping
    LPOLESTR	m_pFileName;		// The filename where we dump to

	E_TSR_FILE_TYPE m_eFileType;	//
	DWORD		m_dwFileAccess;		// Desired file access mode
	DWORD		m_dwFileOpenFlags;	// Desired file open flags
	DWORD		m_dwShareMode;
	
//    CCritSec	m_Lock;				// Main renderer critical section
};

#endif // _TIMESHIFTRECFILE_H_
